<?php
ini_set('display_errors', '1');
error_reporting(E_ALL);
require __DIR__ . '/db.php';
$pdo = db();

echo "<style>body{font-family:system-ui;background:#0f1115;color:#e6e6e6} table{border-collapse:collapse;width:100%} th,td{padding:8px 10px;border-bottom:1px solid #222} th{color:#9aa4b2;text-align:left}</style>";
echo "<h2>Servers</h2>";
$q = $pdo->query("SELECT s.id, a.name AS account, s.domain, s.month, COALESCE(s.price_override, s.auto_price) AS total FROM servers s JOIN accounts a ON a.id=s.account_id ORDER BY a.name, s.domain");
echo "<table><thead><tr><th>Account</th><th>Domain</th><th>Month</th><th>Total</th></tr></thead><tbody>";
foreach ($q as $r) {
    printf("<tr><td>%s</td><td>%s</td><td>%s</td><td>$%.2f</td></tr>",
        htmlspecialchars($r['account']), htmlspecialchars($r['domain']), (int)$r['month'], (float)$r['total']);
}
echo "</tbody></table>";

echo "<h2>Renewals</h2>";
$q = $pdo->query("SELECT a.name AS account, s.domain, r.year, r.due_month, r.status, r.amount_due FROM renewals r JOIN servers s ON s.id=r.server_id JOIN accounts a ON a.id=s.account_id ORDER BY r.year DESC, a.name, s.domain");
echo "<table><thead><tr><th>Account</th><th>Domain</th><th>Year</th><th>Month</th><th>Status</th><th>Amount</th></tr></thead><tbody>";
foreach ($q as $r) {
    printf("<tr><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%s</td><td>$%.2f</td></tr>",
        htmlspecialchars($r['account']), htmlspecialchars($r['domain']), (int)$r['year'], (int)$r['due_month'], htmlspecialchars($r['status']), (float)$r['amount_due']);
}
echo "</tbody></table>";
